----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 09/28/2017 05:10:03 PM
-- Design Name: 
-- Module Name: mult_approx_o4 - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL; 
use IEEE.NUMERIC_STD.ALL; 
use IEEE.STD_LOGIC_UNSIGNED.ALL;
library UNISIM;
use UNISIM.VComponents.all;

entity mult_approx_dacc8 is
generic (word_size: integer:=8); 
Port (
a : in  STD_LOGIC_VECTOR (word_size-1 downto 0);
b : in  STD_LOGIC_VECTOR (word_size-1 downto 0);
prod: out STD_LOGIC_VECTOR (word_size * 2 - 1 downto 0));
end mult_approx_dacc8;

architecture Behavioral of mult_approx_dacc8 is

type data_type is array(14 downto 0) of std_logic_vector(14 downto 0);
signal prop: data_type;
signal gen: data_type;
signal carries: data_type;
signal output: data_type;
type input_carries is array((word_size - 2 ) downto 0) of std_logic_vector(word_size/4 downto 0);
signal input_carry: data_type; --input_carries;
type interm_results is array((word_size - 2) downto 0) of std_logic_vector(word_size downto 0);
signal chain: data_type; --interm_results;
signal anding1 : std_logic;
signal anding2 : std_logic;
signal anding3 : std_logic;
signal temp : std_logic;
signal prod1: STD_LOGIC_VECTOR (word_size + 3 downto 0);
signal prod2: STD_LOGIC_VECTOR (word_size + 3 downto 0);

begin

 set_initial_carry:
    for car in 0 to (word_size - 2) generate
        input_carry(car)(0) <= '0';
    end generate set_initial_carry; 
    
lut_inst_LSB: lut6_2 
              generic map(INIT => X"6AC06AC088888888")
              port map(
              I0 => b(0), --h
              I1 => a(0), --c
              I2 => b(1), -- g
              I3 => a(1), -- d
              I4 => '1',
              I5 => '1',
              O5 => prod1(0),
              O6 => prod1(1)
              );
              
         lut_inst_2: lut6_2 
              generic map(INIT => X"1E665AAAB4CCF000")
              port map(
              I0 => b(0), --h
              I1 => b(1), --c
              I2 => b(2), -- g
              I3 => a(0), -- d
              I4 => a(1),
              I5 => a(2),
              O5 => gen(0)(0),
              O6 => prod1(2)
              );     
    
          ppgen: for i in 1 to 5 generate
                    lut_inst_gen0: lut6_2 
                      generic map(INIT => X"1E665AAAB4CCF000")
                      port map(
                      I0 => b(0), --h
                      I1 => b(1), --c
                      I2 => b(2), -- g
                      I3 => a(i), -- d
                      I4 => a(i+1),
                      I5 => a(i+2),
                      O5 => gen(0)(i),
                      O6 => prop(0)(i)
                      );
                      
                   lut_inst_gen1: lut6_2 
                     generic map(INIT => X"7878787880808080")
                     port map(
                     I0 => b(3), --h
                     I1 => a(i-1), --c
                     I2 => prop(0)(i), -- g
                     I3 => '1', -- d
                     I4 => '1',
                     I5 => '1',
                     --O5 => temp,
                     O6 => prod1(i+2)
                     );
              end generate ppgen;       
            
        lut_inst_8: lut6_2 
             generic map(INIT => X"1E665AAAB4CCF000")
             port map(
             I0 => b(1), --h
             I1 => b(2), --c
             I2 => b(3), -- g
             I3 => a(5), -- d
             I4 => a(6),
             I5 => a(7),
             O5 => gen(0)(6),
             O6 => prod1(8)
             );  
    
         lut_inst_MSB1: lut6_2 
              generic map(INIT => X"6AC06AC080008000")
              port map(
              I0 => b(3), --h
              I1 => a(7), --c
              I2 => b(2), -- g
              I3 => a(6), -- d
              I4 => '1',
              I5 => '1',
              O5 => gen(0)(7),
              O6 => prod1(9)
              );
              
           lut_inst_MSB: lut6_2 
              generic map(INIT => X"7878787880808080")
              port map(
              I0 => b(3), --h
              I1 => a(7), --c
              I2 => gen(0)(7), -- g
              I3 => '1', -- d
              I4 => '1',
              I5 => '1',
              O5 => prod1(11),
              O6 => prod1(10)
              );
           
prod(3 downto 0) <= prod1(3 downto 0);

Type_A: 
        for i in 0 to 7 generate 
            lut_inst0: lut6_2 
            generic map(INIT => X"7878787880808080")
            port map(
            I0 => b(4), --h
            I1 => a(i), --c
            I2 => prod1(i+4), -- g
            I3 => '1', -- d
            I4 => '1',
            I5 => '1',
            O5 => gen(2)(i),
            O6 => prop(2)(i)
            );
        end generate Type_A;

carry_chain_A:
        for z in 0 to 1 generate            
            carry_inst2: CARRY4                                        
            port map (                                                    
            DI => gen(2)(z*4+3 downto z*4),                                             
            S => prop(2)(z*4+3 downto z*4),                                            
            O => output(2)(z*4+3 downto z*4),                                
            CO => carries(2)(z*4+3 downto z*4),                                        
            CI => input_carry(2)(z),                            
            CYINIT => '0'
            );
            input_carry(2)(z+1) <= carries(2)(z*4+3);
            chain(2)(z*4+3 downto z*4) <= output(2)(z*4+3 downto z*4);
        end generate carry_chain_A;
        chain(2)(8) <= carries(2)(7);
        prod(4) <= chain(2)(0);
      
Type_B1: 
                for i in 0 to 7 generate 
                     lut_inst0: lut6_2 
                     generic map(INIT => X"7878787880808080")
                     port map(
                     I0 => b(5), --h
                     I1 => a(i), --c
                     I2 => chain(2)(i+1), -- g
                     I3 => '1', -- d
                     I4 => '1',
                     I5 => '1',
                     O5 => gen(3)(i),
                     O6 => prop(3)(i)
                     );
                     end generate Type_B1;
                     
carry_chain_B1:
                             for z in 0 to 1 generate            
                                  carry_inst2: CARRY4                                        
                                  port map (                                                    
                                  DI => gen(3)(z*4+3 downto z*4),                                             
                                  S => prop(3)(z*4+3 downto z*4),                                            
                                  O => output(3)(z*4+3 downto z*4),                                
                                  CO => carries(3)(z*4+3 downto z*4),                                        
                                  CI => input_carry(3)(z),                            
                                  CYINIT => '0'
                                  );
                                  input_carry(3)(z+1) <= carries(3)(z*4+3);
                                  chain(3)(z*4+3 downto z*4) <= output(3)(z*4+3 downto z*4);
                              end generate carry_chain_B1;
                              chain(3)(8) <= carries(3)(7);
                              prod(5) <= chain(3)(0);
                              
                              Type_B2: 
                              for i in 0 to 7 generate 
                                  lut_inst0: lut6_2 
                                  generic map(INIT => X"7878787880808080")
                                  port map(
                                  I0 => b(6), --h
                                  I1 => a(i), --c
                                  I2 => chain(3)(i+1), -- g
                                  I3 => '1', -- d
                                  I4 => '1',
                                  I5 => '1',
                                  O5 => gen(4)(i),
                                  O6 => prop(4)(i)
                                  );
                              end generate Type_B2;
                              
                              carry_chain_B2:
                              for z in 0 to 1 generate            
                                  carry_inst2: CARRY4                                        
                                  port map (                                                    
                                  DI => gen(4)(z*4+3 downto z*4),                                             
                                  S => prop(4)(z*4+3 downto z*4),                                            
                                  O => output(4)(z*4+3 downto z*4),                                
                                  CO => carries(4)(z*4+3 downto z*4),                                        
                                  CI => input_carry(4)(z),                            
                                  CYINIT => '0'
                                  );
                                  input_carry(4)(z+1) <= carries(4)(z*4+3);
                                  chain(4)(z*4+3 downto z*4) <= output(4)(z*4+3 downto z*4);
                              end generate carry_chain_B2;
                              chain(4)(8) <= carries(4)(7);
                              prod(6) <= chain(4)(0);   
                              
                              Type_B3: 
                              for i in 0 to 7 generate 
                                   lut_inst0: lut6_2 
                                   generic map(INIT => X"7878787880808080")
                                   port map(
                                   I0 => b(7), --h
                                   I1 => a(i), --c
                                   I2 => chain(4)(i+1), -- g
                                   I3 => '1', -- d
                                   I4 => '1',
                                   I5 => '1',
                                   O5 => gen(5)(i),
                                   O6 => prop(5)(i)
                                   );
                              end generate Type_B3;
                              
                              carry_chain_B3:
                              for z in 0 to 1 generate            
                                   carry_inst2: CARRY4                                        
                                   port map (                                                    
                                   DI => gen(5)(z*4+3 downto z*4),                                             
                                   S => prop(5)(z*4+3 downto z*4),                                            
                                   O => output(5)(z*4+3 downto z*4),                                
                                   CO => carries(5)(z*4+3 downto z*4),                                        
                                   CI => input_carry(5)(z),                            
                                   CYINIT => '0'
                                   );
                                   input_carry(5)(z+1) <= carries(5)(z*4+3);
                                   chain(5)(z*4+3 downto z*4) <= output(5)(z*4+3 downto z*4);
                              end generate carry_chain_B3;
                              chain(5)(8) <= carries(5)(7);
                             prod(7) <= chain(5)(0);
                             
 prod(15 downto 8) <= chain(5)(8 downto 1);    

end Behavioral;
